* Master Do File
* Created by Andres Zahler
* File created 10.14.2008
* Last updated 10.22.2008

* This file produces all the data, graphs and tables for the paper.
* Note: to run the tables and graphs all you need is two files: "Cross section 1980-2004.dta" and "FinalDatasetFiveYear.dta" and you can start teh program from 2.-, down below 
* 


* -------------
* GUIDE TO CODE
* -------------

* 1. Generation of the datasets, creation of variables and labels. 
* 2.  Graphs of undervaluation and growth: Figures 1-7
* 3.  Distribution of underval: Figure 8
* 4.  Figure 9: Partial scatterplot of growth against underval, developing countrysample 
* 5.  Figure 10-12: Where to find them
* 6. Table 1: Panel evidence on the growth effects of undervaluation
* 7.  Table 2: Testing for outliers and asymmetries
* 8.  Table 3: Panel Evidence with alternative measures of RER
* 9.  Table 4: Additional covariates in panel regressions (developing countries sample)
* 10.  Table 5:  Cross-section growth regressions (1980-2004)
* 11.  Table 6: Dynamic panel estimation of the growth effects of undervaluation
* 12.  Table 7: Is there a differential impact in industry
* 13.  Table 8 location: Illustrative calculations on the relationship-specificity of tradables
* 14.  Table 9 : Quality of institutions and the growth effects of undervaluation
* 15.  Table 10 : Policy and other determinants of UNDERVAL (full sample)




* -------------------------
* 1. Generation of Datasets
* -------------------------

* a.  Read in PWT data
* b.  Merge in WDI data
* c.  Merge both datasets. 
* d.  Merge in country identifier and continent data
* e.  Merge with Kaufmann and Klinger datasets
* f.  Define undervaluation measure
* g.  Merge with alternative RER measure dataset
* h.  generate the 5 year periods and definition of growth and other variables and labels



* a. Penn World Tables data
* -------------------------

clear
set mem 150m
cd "C:\Data\Rodrik - 08\Final Estimations and Data\final"

* data set from Penn World Tables 6.2

* Key variables:
* - Price Level of GDP (p) [I use this instead of xrate/ppp because this series is more complete than those; some ppp's are 0.000 in the dataset]
* - I redefine p as its inverse, but first divide it by 100 so the base is 1 instead of 100
* - Real GDP per capita (Constant Prices: Chain series) (rgdpch)

insheet using PWT_az.csv, comma
rename p rate
rename country countryPWT
replace rate = 100 / rate
replace countryPWT = "Cote d'Ivoire" if countryPWT == "Cote d`Ivoire"
replace countryisocode="YUG" if countryisocode=="SCG"

save TempPWT, replace
* --------------------------------------




* b.  Add WDI data
* ----------------

* First I need to fix the WDI data.  This code reshapes it from the format in which it downloads on the WDI web site using countries as rows and years as columns.

clear
insheet using WDISectors.csv, names comma
ren 	seriesname variable
ren countryname country
ren countrycode code
drop seriescode
drop if country==""
reshape long yr, i(country variable) j(year)
ren yr y


gen A_GDP :  	"Agriculture, value added (% of GDP)"					= y if variable == "Agriculture, value added (% of GDP)" 
gen I_GDP :  	"Industry, value added (% of GDP)"					= y if variable == "Industry, value added (% of GDP)" 
gen S_GDP :  	"Services, etc., value added (% of GDP)" 				= y if variable == "Services, etc., value added (% of GDP)" 
gen A_Emp :  	"Employment in agriculture (% of total employment)"	= y if variable == "Employment in agriculture (% of total employment)" 
gen I_Emp :  	"Employment in industry (% of total employment)"		= y if variable == "Employment in industry (% of total employment)" 
gen S_Emp :  	"Employment in services (% of total employment)"		= y if variable == "Employment in services (% of total employment)" 
gen X_GDP : 	 	"Exports of goods and services (% of GDP)"				= y if variable == "Exports of goods and services (% of GDP)" 
gen WDI_GDP_curr :	"GDP (current US$)"							= y if variable == "GDP (current US$)" 
gen ManuX :   	"Manufactures exports (% of merchandise exports)"		= y if variable == "Manufactures exports (% of merchandise exports)" 
gen Manu_GDP :	"Manufacturing, value added (% of GDP)"				= y if variable == "Manufacturing, value added (% of GDP)" 
gen MerchX :  	"Merchandise exports (current US$)"					= y if variable == "Merchandise exports (current US$)" 

gen A_VA :       	"Agriculture, value added (constant 2000 US$)"		= y if variable == "Agriculture, value added (constant 2000 US$)" 
gen A_VA_LCU :  	"Agriculture, value added (constant LCU)"				= y if variable == "Agriculture, value added (constant LCU)" 
gen X_VA :      	"Exports of goods and services (constant 2000 US$)"	= y if variable == "Exports of goods and services (constant 2000 US$)" 
gen X_VA_LCU :   	"Exports of goods and services (constant LCU)"		= y if variable == "Exports of goods and services (constant LCU)" 
gen X_VA_LCU_CUR:   "Exports of goods and services (current LCU)"		=y if variable == "Exports of goods and services (current LCU)"
gen IMP_VA_LCU: "Imports of goods and services (constant LCU)"		=y if variable == "Imports of goods and services (constant LCU)"
gen IMP_VA_LCU_CUR: "Imports of goods and services (current LCU)"		=y if variable == "Imports of goods and services (current LCU)"
gen WDI_GDP :     	"GDP (constant 2000 US$)"						= y if variable == "GDP (constant 2000 US$)" 
gen WDI_GDP_LCU :	"GDP (constant LCU)"							= y if variable == "GDP (constant LCU)"  
gen WDI_GDP_PC :  	"GDP per capita (constant 2000 US$)"					= y if variable == "GDP per capita (constant 2000 US$)" 
gen WDI_GDP_PC_LCU:"GDP per capita (constant LCU)"					= y if variable == "GDP per capita (constant LCU)" 
gen I_VA :    	"Industry, value added (constant 2000 US$)"				= y if variable == "Industry, value added (constant 2000 US$)" 
gen I_VA_LCU :	"Industry, value added (constant LCU)"				= y if variable == "Industry, value added (constant LCU)" 
gen M_VA :		"Manufacturing, value added (constant 2000 US$)"		= y if variable == "Manufacturing, value added (constant 2000 US$)" 
gen M_VA_LCU :	"Manufacturing, value added (constant LCU)"				= y if variable == "Manufacturing, value added (constant LCU)" 
gen S_VA :		"Services, etc., value added (constant 2000 US$)"		= y if variable == "Services, etc., value added (constant 2000 US$)" 
gen S_VA_LCU :	"Services, etc., value added (constant LCU)"			= y if variable == "Services, etc., value added (constant LCU)" 
 
drop y variable
sort country year


* Now reduce these multiple observations per country-year into one

harmby A_GDP - S_VA_LCU, by(country year)
duplicates drop

* Now build the TOT index variable
gen TOT_index_WDI=((X_VA_LCU_CUR/X_VA_LCU)/(IMP_VA_LCU_CUR/IMP_VA_LCU))*100

rename country countryWDI
rename code countryisocode
sort countryisocode year
save TempWDI, replace
clear
* -------------------------------------------------------------------------------------------------------------------------------------------------



* c.  Merges the PWT and WDI data
* -------------------------------


* I want to use the dataset underval, which is the original full dataset Dani gave me with the PWT undervaluation data added in

use TempPWT
replace countryisocode = "DEU" if countryisocode == "GER"
sort countryisocode year 
merge countryisocode year using TempWDI


* Can drop observations only in the WDISectors data set if desired
* drop if _m==2
drop _m

sort countryisocode year 
save FinalDataset, replace

erase TempPWT.dta
erase TempWDI.dta

* --------------------------------------




* d.  Add continent dummies to the panel
* --------------------------------------

* This is from http://en.wikipedia.org/wiki/List_of_countries_by_continent_(data_file)

clear
use countries

replace countryisocode = "ZAR" if countryisocode == "COD"
replace countryisocode = "ROM" if countryisocode == "ROU" 

sort countryisocode
merge countryisocode using FinalDataset
drop if _m==1
drop _m


* Now add a couple manually 

replace continent = "EU" if countryisocode == "YUG"
replace continent = "EU" if countryisocode == "SCG"
* (Andorra)
replace continent = "EU" if countryisocode == "ADO"
* (Channel Islands)
replace continent = "EU" if countryisocode == "CHI"
* (Isle of Man)
replace continent = "EU" if countryisocode == "IMY"
* (Timor Leste)
replace continent = "AS" if countryisocode == "TMP"
* (West Bank)
replace continent = "AS" if countryisocode == "WBG"
drop if continent==""


* Now turn that categorical continent variable into dummies
ren continente continent
gen africa = 1 if continent=="AF"
gen asia = 1 if continent=="AS"
gen europe = 1 if continent=="EU"
gen northamerica = 1 if continent=="NA"
gen southamerica = 1 if continent=="SA"
gen oceania = 1 if continent=="OC"

sort countryisocode year
save FinalDataset, replace

* --------------------------------------




* e.  Merge with Kaufmann and Klinger datasets
* ---------------------------------------------

* Now Merge with Kaufmann Dataset
use kaufmann_data, clear
replace countryisocode="SRB" if countryisocode=="YUG"
replace countryisocode="MNE" if countryisocode=="MNP"
replace countryisocode="PLW" if countryisocode=="PCI"
replace countryisocode="WSM" if countryisocode=="SAM"
sort countryisocode year
merge countryisocode year using FinalDataset
drop if _merge==1
drop _merge
save FinalDataset, replace


* Now merge with Bailey Klinger Openforest and Expy variable
sort countryisocode year
merge countryisocode year using Openforest_expy_BK_ready
drop if _merge==2
drop _merge 
save FinalDataset, replace




* f. Define undervaluation measure "underval" and other measurs from WDI
* -----------------------------------------------------------------------

* The RER is already in the right form (appreciation = increase in undervaluation)
* I just need to take out the Balassa-Samuelson effect by controlling for rgdpch
* Use the residuals after regressing ln(rate) on ln(rgdpch) and year dummies, then take logs

gen lnrate = ln(rate)
gen lnrgdpch = ln(rgdpch)
areg lnrate lnrgdpch, absorb(year)
predict underval, resid


* Count unique countries in that regression, in response to a reader's email
gen included = (lnrate!=. & lnrgdpch!=.)
bysort countryPWT: egen countryincluded = max(included)
by countryPWT: gen first=1 if _n==1
tab countryincluded if first==1



* Export share of GDP
gen Xshare = X_VA_LCU / WDI_GDP_LCU		

* Manufacturing share
gen Mshare = M_VA_LCU / WDI_GDP_LCU		


gen Asharegdp = (A_VA_LCU) / (A_VA_LCU + I_VA_LCU + S_VA_LCU) 
gen Isharegdp = (I_VA_LCU) / (A_VA_LCU + I_VA_LCU + S_VA_LCU) 

* Share of tradables (agriculture and industry) versus nontradables (services)
gen ratioAISgdp = (A_VA_LCU + I_VA_LCU) / (A_VA_LCU + I_VA_LCU + S_VA_LCU) 
replace A_Emp = A_Emp / 100
replace I_Emp = I_Emp / 100
replace S_Emp = S_Emp / 100
gen ratioAISemp = A_Emp + I_Emp

sort countryisocode year
save FinalDataset, replace
* -------------------------------------------------------------------------------------------------


* g. Generation and merge with alternative measure dataset. 
* ----------------------------------------------------------

   * Adds WDI data on Savings, TOT, FDI and Fiscal Deficit, and adds the nominal exchange rate
	use wdidata.dta, clear
	sort iso year
	merge iso year using wdi_ner
	drop if _m==2
	*drop if iso=="YUG"
	drop _m

   * Adds the Sturzenegger Exchange regime index
	sort iso year
	merge iso year using sturz_index
	ren country country1
	drop _m

   * Adds the Rogoff-Reinhardt index of exchange rate regime, which includes the IMF definition
	sort iso year
	merge iso year using IRR_indexes
	drop if _m==1
	drop if iso==""
	drop if year<1950
	drop if year==2007
	drop _m

   * Adds, WPIs, CPIs, and Nominal exchange rates from IFS
	sort iso year
	merge iso year using cpierwpi
	drop if year==2007
	drop if _m==2
	drop _m country1 ifs_code

   * Adds a capital account liberalization index from EIU as well as a tariff and non tariff barrier index from EIU
	sort iso year
	merge iso year using EIU_barriers_data
	drop if year>=2007
	drop in 12422/12423

	label variable  wb_ner "nominal exchange rate _ WDI"
	label variable nom_er `"nominal exchange rate (year avg) _ IFS"'
	label variable irr_index_coarseclass `"Rogoff-Reinhardt coarse class er regime index"'


	order  iso_code year wb_ner
	ren wb_ner ner_wdi
	order  nom_er iso_code year ner_wdi nom_er wpi cpi
	order  iso_code year nom_er ner_wdi wpi cpi
	order  iso_code - cpi  rexchind  gdspgdp gnsinctrpgdp
	ren  tot tot1_wdi
	ren tot2 tot2_wdi
	ren tot3 tot3_wdi
	ren nbtt nbtt_wdi
	ren rexchind rexchind_wdi
	ren cpi cpi_ifs
	ren wpi wpi_ifs
	ren nom_er ner_ifs
	ren  gdspgdp gdspgdp_wdi
	ren  gnsinctrpgdp gnsinctrpgdp_wdi
	ren  csdpgdp csdpgdp_wdi
	ren fdinipgdp fdinipgdp_wdi
	order  iso_code - tot3_wdi  irr_index_fineclass irr_index_coarseclass irr_imf_index sturz_index5 sturz_index3 sturz_outlier_5 sturz_pegtoabasket_5 sturz_outlier_3 sturz_pegtoabasket_3 CapAcLib_index_EIU T_and_NT_barriers_EIU
	order iso country year
	ren   irr_index_fineclass er_regime_index_fineclass_RR
	ren  irr_index_coarseclass  er_regime_index_coarseclass_RR
	ren  irr_imf_index  er_regime_index_IMFclass_RR


	label variable  iso_code "standard country code"
	label variable  sturz_index3 "Sturzenegger ER_regime index 3 way classification"
	label variable  sturz_index5 "Sturzenegger ER_regime index 5 way classification"
	label variable  sturz_outlier_3 "1 if the datapoint was an outlier in the 3 way index"
	label variable  sturz_outlier_5 "1 if the datapoint was an outlier in the 5 way index"
	label variable  sturz_pegtoabasket_3 "1 if the currency was pegged to basket of currencies for 3 way index"
	label variable  sturz_pegtoabasket_5 "1 if the currency was pegged to basket of currencies for 5 way index"
	label variable wpi `"Wholesale / Producer price index 2000=100 _ IFS"'
	label variable cpi `"CPI 2000=100 _ IFS"'
	label variable csdpgdp `"Government Cash surplus/deficit (% of GDP)'(WDI) 2007"'
	label variable er_regime_index_fineclass_RR `"Rogoff-Reinhardt fine class er regime index"'
	label variable er_regime_index_fineclass_RR `"Rogoff-Reinhardt fine classification er regime index"'
	label variable er_regime_index_coarseclass_RR `"Rogoff-Reinhardt coarse classification er regime index"'
	label variable er_regime_index_IMFclass_RR `"IMF classification of er regimes, according to Rogoff-Reinhardt"'
	label variable tot1_wdi `"ToT as (cteM/cuM)/(cteX/cuX) US, 2000=100 _ WDI"'
	label variable tot2_wdi `"ToT as ipm/ipx US, 2000=100 _ WDI"'
	label variable tot3_wdi `"ToT as (cteM/cuM)/(cteX/cuX) LCU, diff base year _ WDI"'
	label variable CapAcLib_index_EIU `"Capital account liberalization index 5=high _ EIU"'
	label variable T_and_NT_barriers_EIU `"Tariff and non-tariff barriers (5=low) _EIU"'



	drop _m latin_subregion  ind

   * generates USPPI for every country
	gen us_ppi=wpi_ifs if iso=="USA"
	bysort year: egen us_ppi2=max(us_ppi)
	format iso %5s
	drop us_ppi
	ren us_ppi2 us_ppi
	order  iso_code - cpi_ifs us_ppi


	sort iso year
  * Adds GPD and govt consumption and gdp from WDI
	merge iso year using "gov_exp and gdp"
	drop if _merge==2
	drop _merge
	drop countryname

	label variable gdp_ct_lcu "GDP constant LCU _ WDI"
	label variable gdp_ct_us "GDP constant 2000 US$ _ WDI"
	label variable govt_cons_pergdp "government consumption (% GDP)  _ WDI"
	label variable us_ppi `"US wholesale/producer price index _ IFS"'

	sort iso 

  *  Adds continent dummies
	merge iso using dummies_continent
	drop if _merge==2
	drop _merge
	drop hola
	drop africa
	ren lac dlac

	sort iso year

   * Adds years of education from Barro-Lee
	merge iso year using years_education_with_iso
	drop _merge
	label variable tyr `"average years of education - >25 years _ BarroLee"'
	label variable tyr15 `"average years of education - >15 years _ BarroLee"'
	label variable tyrm15 `"Male average years of education - >15 years _ BarroLee"'
	label variable tyrm `"Male average years of education - >25 years _ BarroLee"'


	sort iso year

   * Adds log (1+inflation rate) from WDI and IFS

	merge iso year using "log inflation"
	drop if _merge==2
	ren inflation inflation_wdi
	label variable inflation_wdi "log (1+ year inflation rate) _ WDI"
	sort iso year
	bysort iso: gen inf2=cpi/cpi[_n-1]-1
	gen inf3=log(1+inf2)
	drop inf2
	ren inf3 inflation_ifs
	label variable inflation_ifs "log (1+ year inflation rate) _ IFS"
	drop _merge

	sort iso year 

   * Adds Chinn Index of Capital Account openness
	merge iso year using kopen
	drop _m
	label variable kaopen "Chinn Index of Capital Account openness"

	sort iso 

   * Adds Rodrik definition of ER regime using RR
	sort iso year
	merge iso year using er_RR_Rodrik
	drop _m
	sort iso

   * Adds information about what was used to construct RER, WPI or CPI

	merge iso using "wpicpi selection"
	gen wpi2=wpi_ifs*dwpi
	gen cpi2=cpi_ifs*dcpi
	egen wpicpi2a=rowtotal(wpi2 cpi2)
	gen wpi3=wpi_ifs*dwpi if  years_cpi_wpi >=20
	gen cpi3=cpi_ifs*dcpi if years_cpi>=20
	egen wpicpi3a=rowtotal(wpi3 cpi3)
	drop _merge
	order  iso_code - us_ppi wpicpi2a wpicpi3a
	gen rer_ifs= ner_ifs * us_ppi / wpicpi3a
	order iso_code country year rer_ifs
	label variable rer_ifs "real exchange rate = nom_er*US_WPI/WPI or CPI if the country has 20 years or more of CPI/WPI"
	drop  country_name cpi_wpi wpi2 cpi2 wpi3 cpi3  wpicpi2a wpicpi3a
	label variable dcpi "dummy if used cpi for rer calculation"
	label variable dwpi "dummy if used wpi for rer calculation"
	label variable years_cpi_wpi "number of years of CPI or WPI for the country"

	sort iso year

   * Saves the added variables as "final data", and the merged database as "FinalDatasetExtra"

	save "final data", replace
	use "FinalDataset", clear
	drop  countryK
	ren countryisocode iso_code
	sort iso year
	merge iso year using "final data"
	drop if year==2007
	drop if _m==1
	drop _m


   * Generates the real exchange rate variables used in table 3. 

	gen lnrer_pwt=ln(xrat/ppp)
	gen lnrer_wpi=ln( ner_wdi* us_ppi/ wpi_ifs)
	gen lnrer_cpi=ln( ner_wdi* us_ppi/ cpi_ifs)
	

	sort iso year


   * Generates lntot for table 10
     gen ltot_wdi=log(tot1)	

	save FinalDatasetExtra, replace



use FinalDatasetExtra, clear





* h.  generate the 5 year periods and definition of growth
* ----------------------------------------------------------


* 5-YEAR AVERAGE REGRESSIONS

* Create the periods

gen period = 50 if year >=1950 & year <=1954
replace period = 55 if year >=1955 & year <=1959
replace period = 60 if year >=1960 & year <=1964
replace period = 65 if year >=1965 & year <=1969
replace period = 70 if year >=1970 & year <=1974
replace period = 75 if year >=1975 & year <=1979
replace period = 80 if year >=1980 & year <=1984
replace period = 85 if year >=1985 & year <=1989
replace period = 90 if year >=1990 & year <=1994
replace period = 95 if year >=1995 & year <=1999
replace period = 100 if year >=2000 & year <=2004
replace period = 105 if year >=2005
*drop if year > 2004

ren iso_code countryisocode

* Define 5-year-average variables
*** (for some reason stata doesn't allow me to use the name TOT_index_WDI while collapsing)
order year  countryisocode rule corruption govt_effec regulation

collapse rule-regulation  xrat- rgdptt  A_GDP-oceania OF2-underval Xshare- ratioAISemp  rer_ifs-ltot_wdi, by(countryisocode period continent )

order  countryisocode period continent
rename period period_code




* Create growth variable
* ----------------------

* Definition of growth for, say, 1955-1959:
* [log (avg income over 1955-1959) - log (avg income over 1950-1954)] / 5

sort countryisocode period_code
by countryisocode: gen growthrate = (lnrgdpch - lnrgdpch[_n-1])/5

* creation of variables and labels
* --------------------------------
sort countryisocode period_code
bysort countryisocode: gen lninitincome = lnrgdpch[_n-1]
label var lninitincome "ln initial income"

* I generate de ln of TOT from WDI and from PWT, respectively
gen ltot=log(TOT_index_WDI)

gen str countryperiod = countryisocode + string(period_code)
label var underval "ln UNDERVAL"

egen countrycode=group(countryisocode)
label var growthrate "per-capita GDP growth"
label var period_code "Year"

replace govt_cons_pergdp =govt_cons_pergdp /100
replace gdspgdp_wdi =gdspgdp_wdi /100

* I generate the log of the real exchange rate from WDI-IMF
replace rexchind_wdi=100/rexchind_wdi 
gen lnrer_imf=ln( rexchind)



save FinalDatasetFiveYear, replace

* --------------------------------------




* ----------------------------------------------------
* 2. Graphs of undervaluation and growth : Figures 1-7
* -----------------------------------------------------

replace growthrate = growthrate * 100

* China, India, South Korea, Taiwan, Uganda, Tanzania, Mexico


* Figure 1
twoway (line underval period_code, c(l) yaxis(2) color(gs0) lwidth(medium)) ///
(line growthrate period_code, c(l) yaxis(1) color(gs6) lpattern(dash) lwidth(medium)) if countryisocode=="CHN" & period<105, ///
xtitle(Period) legend(label(1 ln UNDERVAL) label(2 per-capita GDP growth))  ///
ytitle(per-capita GDP growth (%), axis(1)) ytitle(ln UNDERVAL, axis(2)) 
graph export China.wmf, replace

* Figure 2
twoway (line underval period_code, c(l) yaxis(2) color(gs0) lwidth(medium)) ///
(line growthrate period_code, c(l) yaxis(1) color(gs6) lpattern(dash) lwidth(medium)) if countryisocode=="IND" & period<105, ///
xtitle(Period) legend(label(1 ln UNDERVAL) label(2 per-capita GDP growth))  ///
ytitle(per-capita GDP growth (%), axis(1)) ytitle(ln UNDERVAL, axis(2)) 
graph export India.wmf, replace

* Figure 3
twoway (line underval period_code, c(l) yaxis(2) color(gs0) lwidth(medium)) ///
(line growthrate period_code, c(l) yaxis(1) color(gs6) lpattern(dash) lwidth(medium)) if countryisocode=="KOR" & period<105, ///
xtitle(Period) legend(label(1 ln UNDERVAL) label(2 per-capita GDP growth))  ///
ytitle(per-capita GDP growth (%), axis(1)) ytitle(ln UNDERVAL, axis(2)) 
graph export Korea.wmf, replace

* Figure 4
twoway (line underval period_code, c(l) yaxis(2) color(gs0) lwidth(medium)) ///
(line growthrate period_code, c(l) yaxis(1) color(gs6) lpattern(dash) lwidth(medium)) if countryisocode=="TWN" & period<105, ///
xtitle(Period) legend(label(1 ln UNDERVAL) label(2 per-capita GDP growth))  ///
ytitle(per-capita GDP growth (%), axis(1)) ytitle(ln UNDERVAL, axis(2)) 
graph export Taiwan.wmf, replace

* Figure 5
twoway (line underval period_code, c(l) yaxis(2) color(gs0) lwidth(medium)) ///
(line growthrate period_code, c(l) yaxis(1) color(gs6) lpattern(dash) lwidth(medium)) if countryisocode=="UGA" & period<105, ///
xtitle(Period) legend(label(1 ln UNDERVAL) label(2 per-capita GDP growth))  ///
ytitle(per-capita GDP growth (%), axis(1)) ytitle(ln UNDERVAL, axis(2)) 
graph export Uganda.wmf, replace

* Figure 6
twoway (line underval period_code, c(l) yaxis(2) color(gs0) lwidth(medium)) ///
(line growthrate period_code, c(l) yaxis(1) color(gs6) lpattern(dash) lwidth(medium)) if countryisocode=="TZA" & period<105, ///
xtitle(Period) legend(label(1 ln UNDERVAL) label(2 per-capita GDP growth))  ///
ytitle(per-capita GDP growth (%), axis(1)) ytitle(ln UNDERVAL, axis(2)) 
graph export Tanzania.wmf, replace

* Figure 7
twoway (line underval period_code, c(l) yaxis(2) color(gs0) lwidth(medium)) ///
(line growthrate period_code, c(l) yaxis(1) color(gs6) lpattern(dash) lwidth(medium)) if countryisocode=="MEX" & period<105, ///
xtitle(Period) legend(label(1 ln UNDERVAL) label(2 per-capita GDP growth))  ///
ytitle(per-capita GDP growth (%), axis(1)) ytitle(ln UNDERVAL, axis(2)) 
graph export Mexico.wmf, replace
* --------------------------------------

replace growthrate = growthrate / 100



* --------------------------------------
* 3. Distribution of underval: Figure 8
* --------------------------------------

histogram underval, ytick(0(.2)1) ylabel(0(.2)1, grid) xtitle(UNDERVAL)
graph export histunderval.wmf, replace

* --------------------------------------



* --------------------------------------------------
* 3.1. Variable definitions for Table 1 and Figure 9
* --------------------------------------------------


* Defining developing economies
*average GDP in the whole sample <6000
by countryiso: egen meangdp=mean( rgdpch)
by countryiso: egen meangdpin=mean( rgdpch) if period <80
by countryiso: egen meangdpfi=mean( rgdpch) if period >=80


*min GDP independent of the year

egen mingdpa=tag( rgdpch)
by countryiso: egen minyeargdp=min(period) if mingdpa==1
replace mingdpa=0 if period!=minyeargdp
gen initialgdpa= rgdpch if period==minyeargdp
by countryiso: egen initialgdp=max(initialgdpa)
drop initialgdpa



* --------------------------------------------------------------------------------------
* 4.  Figure 9: Partial scatterplot of growth against underval, developing countrysample 
* --------------------------------------------------------------------------------------

* This is column 3 of Table 1
local controls lninitincome underval
quietly xi: reg growthrate `controls' i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK") & (rgdpch < 6000) & period<105, robust

cprplot underval, mlabel(countryperiod) mlabsize(vsmall) msize(vsmall)  mcolor(gs0) mlabcolor(gs8)
graph export Figure9.wmf, replace

* --------------------------------------

* -------------------------------------
* 5.  Figure 10-12: Where to find them
* -------------------------------------

* Figure 10: Growth accelerations and UNDERVAL
* Found in the TAG "G Figure 10" in the excel file "Figures and Tables Paper Final.xls"

* Figures 11 - 13: The source is Dani Rodrik himself. 



* ------------------------------------------------------------------
* 6. Table 1: Panel evidence on the growth effects of undervaluation
* ------------------------------------------------------------------
* note: The formated table can be found in the tag: "Table 1" in in the excel file

gen yinitial_underval_interac=underval*lninitincome

local controls lninitincome underval


xi: reg growthrate `controls' i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK"), robust
outreg2 lninitincome underval using Table_1, excel ctitle(All countries) tstat bdec(3) tdec(2) nocons nor2 replace 

xi: reg growthrate lninitincome underval i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK") & (rgdpch > 6000), robust
outreg2 lninitincome underval using Table_1, excel ctitle(Developed countries, RGDPCH > $6000)  tstat bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg growthrate `controls' i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK") & (rgdpch < 6000), robust
outreg2 lninitincome underval using Table_1, excel ctitle(Developing countries, RGDPCH < $6000) tstat bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg growthrate `controls'  yinitial_underval_interac i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK"), robust
outreg2 lninitincome underval  yinitial_underval_interac using Table_1, excel ctitle(All countries) tstat bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg growthrate `controls' i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK") & (rgdpch < 6000) & (period_code < 80), robust
 outreg2 lninitincome underval using Table_1, excel ctitle(Developing countries RGDPCH < $6000, 1950-1979) tstat bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg growthrate `controls' i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK") & (rgdpch < 6000) & (period_code > 79), robust
 outreg2 lninitincome underval using Table_1, excel ctitle(Developing countries RGDPCH < $6000, 1980-2004) tstat bdec(3) tdec(2) nocons nor2 nonotes append

** NOTE: the table shows slightly different results compared to the paper
* --------------------------------------



* -------------------------------------------------
* 7.  Table 2: Testing for outliers and asymmetries
* -------------------------------------------------
* note: The formated table can be found in the tag: "Table 2" in in the excel file

* This is based on column 1 of Table 1

local controls lninitincome underval

xi: reg growthrate `controls' i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK") & (rgdpch < 6000), robust
outreg2 underval using Table_2, ctitle(Baseline)  excel tstat bdec(3) tdec(2) nocons nor2 replace

xi: reg growthrate `controls' i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK") & (rgdpch < 6000) & (underval > -1.5), robust
outreg2 underval using Table_2, ctitle(UNDERVAL greater than -1.50) excel tstat bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg growthrate `controls' i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK") & (rgdpch < 6000) & (underval > -1), robust
outreg2 underval using Table_2, ctitle(UNDERVAL greater than -1.00) excel tstat bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg growthrate `controls' i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK") & (rgdpch < 6000) & (underval > -.5), robust
outreg2 underval using Table_2, ctitle(UNDERVAL greater than -0.50) excel tstat bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg growthrate `controls' i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK") & (rgdpch < 6000) & (underval > -.25), robust
outreg2 underval using Table_2, ctitle(UNDERVAL greater than -0.25) excel tstat bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg growthrate `controls' i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK") & (rgdpch < 6000) & (underval > -.5) & (underval < .5), robust
outreg2 underval using Table_2, ctitle(UNDERVAL between -0.50 and 0.50) excel tstat bdec(3) tdec(2) nocons nor2 nonotes append

* --------------------------------------


* ------------------------------------------------------------
* 8.  Table 3: Panel Evidence with alternative measures of RER
* ------------------------------------------------------------


xi: reg growthrate lninit lnrer_pwt  i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK" & countryisocode!="USA"), robust
outreg2 lninit lnrer_pwt  using Table_3, excel ctitle(All countries) tstat bdec(3) tdec(2) nocons nor2 replace 

xi: reg growthrate lninit lnrer_pwt  i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK") & (rgdpch < 6000), robust
outreg2 lninit lnrer_pwt  using Table_3, excel ctitle(Developing countries, RGDPCH < $6000) tstat bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg growthrate lninitincome lnrer_imf i.countryisocode i.period_code if (countryisocode!="NIC" & countryisocode!="USA"), robust
outreg2 lninitincome lnrer_imf using Table_3, excel ctitle(All countries) tstat bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg growthrate lninitincome lnrer_imf i.countryisocode i.period_code if (countryisocode!="NIC" & countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK") & (rgdpch < 6000), robust
outreg2 lninitincome lnrer_imf using Table_3, excel ctitle(Developing countries, RGDPCH < $6000) tstat bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg growthrate lninitincome lnrer_wpi i.countryisocode i.period_code if (countryisocode!="USA"), robust
outreg2 lninitincome lnrer_wpi using Table_3, excel ctitle(All countries) tstat bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg growthrate lninitincome lnrer_wpi i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK") & (rgdpch < 6000), robust
outreg2 lninitincome lnrer_wpi using Table_3, excel ctitle(Developing countries, RGDPCH < $6000) tstat bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg growthrate lninitincome lnrer_cpi i.countryisocode i.period_code if (countryisocode!="USA"), robust
outreg2 lninitincome lnrer_cpi using Table_3, excel ctitle(All countries) tstat bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg growthrate lninitincome lnrer_cpi i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK") & (rgdpch < 6000), robust
outreg2 lninitincome lnrer_cpi using Table_3, excel ctitle(Developing countries, RGDPCH < $6000) tstat bdec(3) tdec(2) nocons nor2 nonotes append


* ------------------------------------------------------------
* 9.  Table 4: Additional covariates in panel regressions (developing countries sample)
* ------------------------------------------------------------


local controls lninitincome underval

xi: reg growthrate `controls' i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK") & (rgdpch < 6000), robust
outreg2 lninitincome underval using Table_4, excel ctitle(Developing countries, RGDPCH < $6000) tstat bdec(3) tdec(2) nocons nor2 replace 

xi: reg growthrate `controls' rule  i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK")  & rgdpch<6000, robust  
outreg2 lninitincome underval rule  using Table_4, excel ctitle(Developing countries, RGDPCH < $6000) tstat bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg growthrate `controls' govt_cons_pergdp i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK")  & rgdpch<6000, robust   
outreg2 lninitincome underval govt_cons_pergdp using Table_4, excel ctitle(Developing countries, RGDPCH < $6000) tstat bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg growthrate `controls' govt_cons_pergdp ltot i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK")  & rgdpch<6000, robust      
outreg2 lninitincome underval govt_cons_pergdp ltot using Table_4, excel ctitle(Developing countries, RGDPCH < $6000) tstat bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg growthrate `controls' ltot inflation_wdi i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK")  & rgdpch<6000, robust 
outreg2 lninitincome underval ltot inflation_wdi using Table_4, excel ctitle(Developing countries, RGDPCH < $6000) tstat bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg growthrate `controls' inflation_wdi  gdspgdp_wdi i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK")  & rgdpch<6000, robust  
outreg2 lninitincome underval inflation_wdi  gdspgdp_wdi using Table_4, excel ctitle(Developing countries, RGDPCH < $6000) tstat bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg growthrate `controls' inflation_wdi gdspgdp_wdi tyr15 i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK")  & rgdpch<6000, robust
outreg2 lninitincome underval inflation_wdi gdspgdp_wdi tyr15 using Table_4, excel ctitle(Developing countries, RGDPCH < $6000) tstat bdec(3) tdec(2) nocons nor2 nonotes append

* -----------------------------------------------------------------------------
* 10.  Table 5:  Cross-section growth regressions (1980-2004)
* -----------------------------------------------------------------------------


use "Cross section 1980-2004", clear
gen tyr15_100=tyr15/100
replace govt_cons_pergdp =govt_cons_pergdp /100
replace gdspgdp_wdi =gdspgdp_wdi /100


reg growth lnrgdpch80 underval tyr15_100 rule, robust
outreg2 lnrgdpch80 underval tyr15_100 rule using Table_5, excel tstat bdec(3) tdec(2) nocons replace 

reg growth lnrgdpch80 underval tyr15_100 rule  govt_cons_pergdp, robust
outreg2 lnrgdpch80 underval tyr15_100 rule  govt_cons_pergdp using Table_5, excel tstat bdec(3) tdec(2) nocons nonotes append

reg growth lnrgdpch80 underval tyr15_100 rule  govt_cons_pergdp inflation_wdi, robust
outreg2 lnrgdpch80 underval tyr15_100 rule  govt_cons_pergdp inflation_wdi using Table_5, excel tstat bdec(3) tdec(2) nocons nonotes append

reg growth lnrgdpch80 underval tyr15_100 rule   gdspgdp_wdi, robust
outreg2 lnrgdpch80 underval tyr15_100 rule   gdspgdp_wdi  using Table_5, excel tstat bdec(3) tdec(2) nocons nonotes append

reg growth lnrgdpch80 underval tyr15_100 rule   gdspgdp_wdi dafrica dlac dasia, robust
outreg2 lnrgdpch80 underval tyr15_100 rule   gdspgdp_wdi dafrica dlac dasia using Table_5, excel tstat bdec(3) tdec(2) nocons nonotes append

reg growth lnrgdpch80 underval rule   gdspgdp_wdi dafrica dlac dasia, robust
outreg2 lnrgdpch80 underval rule   gdspgdp_wdi dafrica dlac dasia using Table_5, excel tstat bdec(3) tdec(2) nocons nonotes append

reg growth lnrgdpch80 underval rule  dafrica dlac dasia, robust
outreg2 lnrgdpch80 underval rule  dafrica dlac dasia using Table_5, excel tstat bdec(3) tdec(2) nocons nonotes append

* -----------------------------------------------------------------------------
* 11.  Table 6: Dynamic panel estimation of the growth effects of undervaluation
* -----------------------------------------------------------------------------
use FinalDatasetFiveYear, clear

drop if period==105

cap log close
log using arellano_bond.txt, text replace

ren period_code year
tsset countrycode year, delta(5)

** One Lag
** Full sample

*** Two Step System GMM, assuming exogeneity only for initial income and time dummies, 
*** small sample, using forward orthogonal deviations, instead of first differencing (due to limited data)

xi: xtabond2 growthrate l.growthrate lninitincome underval i.year if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK")  , ///
gmm(l.growthrate  underval) iv(i.year   lninitincome) robust two small orthogonal nodiffsargan
outreg2 l.growthrate underval lninitincome using Table_6, ///
ctitle(Arellano Bond estimator, system) excel tstat bdec(3) tdec(2) nocons nor2 replace


*** Two Step Difference GMM, assuming exogeneity only for initial income and time dummies, 
*** small sample, using forward orthogonal deviations, instead of first differencing (due to limited data)

xi: xtabond2 growthrate l.growthrate lninitincome underval  i.year if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK")  , ///
gmm(l.growthrate  underval) iv(i.year   lninitincome) robust two small orthogonal nodiffsargan noleveleq
outreg2 l.growthrate underval lninitincome using Table_6, ///
ctitle(Arellano Bond estimator, difference) excel tstat bdec(3) tdec(2) nonotes nocons nor2 append


** Developing Economies

*** Two Step System GMM, assuming exogeneity only for initial income and time dummies, 
*** small sample, using forward orthogonal deviations, instead of first differencing (due to limited data)

xi: xtabond2 growthrate l.growthrate lninitincome underval i.year if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK") &  rgdpch<=6000  , ///
gmm(l.growthrate  underval) iv(i.year   lninitincome) robust two small orthogonal nodiffsargan
outreg2 l.growthrate underval lninitincome using Table_6, ///
ctitle(Arellano Bond estimator, system) excel tstat bdec(3) tdec(2) nonotes nocons nor2 append


*** Two Step Difference GMM, assuming exogeneity only for initial income and time dummies, 
*** small sample, using forward orthogonal deviations, instead of first differencing (due to limited data)

xi: xtabond2 growthrate l.growthrate lninitincome underval i.year if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK") & rgdpch<=6000, ///
gmm(l.growthrate  underval) iv(i.year   lninitincome) robust two small orthogonal nodiffsargan noleveleq
outreg2 l.growthrate underval lninitincome using Table_6, ///
ctitle(Arellano Bond estimator, difference) excel tstat bdec(3) tdec(2) nocons nor2 nonotes append



** Developed Economies

*** Two Step System GMM, assuming exogeneity only for initial income and time dummies, 
*** small sample, using forward orthogonal deviations, instead of first differencing (due to limited data)

xi: xtabond2 growthrate l.growthrate lninitincome underval i.year if  rgdpch>6000, ///
gmm(l.growthrate  underval) iv(i.year   lninitincome) robust two small orthogonal nodiffsargan
outreg2 l.growthrate underval lninitincome using Table_6, ///
ctitle(Arellano Bond estimator, system) excel tstat bdec(3) tdec(2) nonotes nocons nor2 append


*** Two Step Difference GMM, assuming exogeneity only for initial income and time dummies, 
*** small sample, using forward orthogonal deviations, instead of first differencing (due to limited data)

xi: xtabond2 growthrate l.growthrate lninitincome underval i.year if  rgdpch>6000, ///
gmm(l.growthrate  underval) iv(i.year   lninitincome) robust two small orthogonal nodiffsargan noleveleq
outreg2 l.growthrate underval lninitincome using Table_6, ///
ctitle(Arellano Bond estimator, difference) excel tstat bdec(3) tdec(2) nocons nor2 nonotes append

ren year period_code
log close

* --------------------------------------




* ----------------------------------------------------------
* 12.  Table 7: Is there a differential impact in industry
* ----------------------------------------------------------
xi: reg   Isharegdp lnrgdpch  underval i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK"), robust
outreg2  lnrgdpch underval using Table_7, excel ctitle(Industry share in GDP LCU) tstat bdec(3) tdec(2) nocons nor2 nonotes replace

xi: reg    I_Emp lnrgdpch  underval i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK"), robust
outreg2  lnrgdpch underval using Table_7, excel ctitle(Industry share in employment) tstat  bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg   Asharegdp lnrgdpch  underval i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK"), robust
outreg2  lnrgdpch underval using Table_7, excel ctitle(Agriculture share in GDP LCU) tstat  bdec(3) tdec(2) nocons nor2 nonotes append

xi: reg    A_Emp lnrgdpch  underval i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK"), robust
outreg2  lnrgdpch underval using Table_7, excel ctitle(Agriculture share in employment)tstat  bdec(3) tdec(2) nocons nor2 nonotes append

xi: ivregress 2sls  growthrate  lninitincome i.countryisocode i.period_code (Isharegdp = lnrgdpch  underval  lninitincome) if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK"), robust
outreg2 lninitincome Isharegdp using Table_7, ctitle(Growth - TSLS)  excel bdec(3) tdec(2) tstat nocons nor2 nonotes append

xi: ivregress 2sls  growthrate  lninitincome i.countryisocode i.period_code (I_Emp = lnrgdpch  underval  lninitincome) if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK"), robust
outreg2 lninitincome I_Emp using Table_7, ctitle(Growth - TSLS)  excel bdec(3) tdec(2)tstat  nocons nor2 nonotes append


* ----------------------------------------------------------
* 13.  Table 8 location: Illustrative calculations on the relationship-specificity of tradables
* ----------------------------------------------------------
* This table is in the paper itself, so the source is Dani Rodrik. 


* ----------------------------------------------------------
* 14.  Table 9 : Quality of institutions and the growth effects of undervaluation
* ----------------------------------------------------------


	****----------------------------------------------------------------------------------------------------
	****Generation of groups of countries according to different levels of insitutions, expy and open forest
	**** And redoing of Table 1 with interactions with those different groups
	****----------------------------------------------------------------------------------------------------



	*----------------------
	*i.- Creation of Groups
	*-----------------------


	* a) For institutions
	*---------------------

	use kaufmann_data, clear

	by   countryisocode: egen mean_rule=mean(rule)
	by   countryisocode: egen mean_corrupt=mean(corrupt)
	by   countryisocode: egen mean_gov_eff=mean( govt_effec)
	by   countryisocode: egen mean_reg=mean(  regulation)
	egen mean_mean=rowmean( mean_rule mean_corrupt mean_gov_eff mean_reg)
	collapse  mean_rule mean_corrupt mean_gov_eff mean_reg mean_mean, by( countryK countryisocode)

	replace countryisocode="MNE" if countryisocode=="MNP"
	replace countryisocode="PLW" if countryisocode=="PCI"
	replace countryisocode="WSM" if countryisocode=="SAM"

	sort countryisocode

	save kaufmann_data_means, replace



	* b) for GDP per capita
	*----------------------

	use FinalDataset, clear

	keep  countryK countryisocode year rgdpch
	keep if year>=1996 & year<=2004
	bysort  countryisocode: egen avggdppc=mean( rgdpch)
	collapse  avggdppc, by( countryisocode)
	sort  countryisocode
	save rgdppc_means, replace

	*c) I merge the two a) and b) and I add the expy and open forest means (which I already took the average in a separate file)
	*----------------------------------------------------------------------------------------------------------------------------
	
	merge countryisocode using kaufmann_data_means
	drop if _m==2
	drop _m

	gen lavggdppc=log( avggdppc)
	gen hola=1


	*d) generates groups according to above average or below average (controling for GDPPC)
	*--------------------------------------------------------------------------------------
	* average of 4 institutional indexes

	reg   mean_mean lavggdppc, robust
	predict mean_inst_avg_hat

	gen rank_inst= mean_mean- mean_inst_avg_hat

	gsort - rank_inst
	gen rankrank_inst=sum(hola) if rank_inst!=.
	gen groupinst_avg=1 if rankrank_inst<=63
	replace groupinst_avg=2 if rankrank_inst>63 & rankrank_inst<=125
	replace groupinst_avg=3 if rankrank_inst>125 & rankrank_inst!=.



	* e) cleaning and saving the file
	* ---------------------
	drop hola countryK
	sort countryisocode
	keep countryisocode group*

	save means_for_groups, replace


	*------------------------------------------------------------------------------------------------------------------------------


	*----------------
	*ii.- Regressions
	*----------------

	use FinalDatasetFiveYear, clear
	sort countryisocode
	merge countryisocode using means_for_groups
	drop _m

	set matsize 500
	sort countryisocode period_code
	label var lninitincome "Log initial income"




	local controls lninitincome underval


	**-------------------------------------------------------------------------------------
	**Table 9, columns 1-4: dividing by groups of according to average institutional index (4 indexes)
	**-------------------------------------------------------------------------------------

	* Table 1.2a

	xi: reg growthrate `controls' i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK"), robust 
	outreg2 lninitincome underval using Table_9, excel ctitle(All countries) tstat bdec(3) tdec(2) nocons nor2 replace 

	xi: reg growthrate `controls' i.countryisocode i.period_code ///
	if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK")& groupinst_avg==1, robust 
	outreg2 lninitincome underval using Table_9, excel ctitle(Above average - Avg Index Institutional Quality) tstat bdec(3) tdec(2) nocons nor2 nonotes append 
	xi: reg growthrate `controls' i.countryisocode i.period_code ///
	if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK")& groupinst_avg==2, robust 
	outreg2 lninitincome underval using Table_9, excel ctitle(Around average - Avg Index Institutional Quality) tstat bdec(3) tdec(2) nocons nor2 nonotes append 
	xi: reg growthrate `controls' i.countryisocode i.period_code ///
	if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK")& groupinst_avg==3, robust 
	outreg2 lninitincome underval using Table_9, excel ctitle(Below average - Avg Index Institutional Quality) tstat bdec(3) tdec(2) nocons nor2 nonotes append 


	*------------------------------------------------------------------------
	*Table 9, column 5:  Finally, regression with interacted dummies, not to lose datapoints
	*-----------------------------------------------------------------------

	*a) Generation of dummies and interaction effects

	gen dinst_2=0 if groupinst_avg!=.
	replace dinst_2=1 if groupinst_avg==2
	gen dinst_3=0 if groupinst_avg!=.
	replace dinst_3=1 if groupinst_avg==3
	gen under_dinst2=underval*dinst_2
	gen under_dinst3=underval*dinst_3

	* b) Tables/Regressions

	*** Institutional Index


	xi: reg growthrate `controls' under_dinst2 under_dinst3  i.countryisocode i.period_code if (countryisocode!="IRQ" & countryisocode!="LAO" & countryisocode!="PRK"), robust
	outreg2 lninitincome underval under_dinst2 under_dinst3  using Table_9, excel ctitle(All countries - Interaction Index Institutions) tstat bdec(3) tdec(2) nocons nor2 nonotes append


* ----------------------------------------------------------
* 15.  Table 10 : Policy and other determinants of UNDERVAL (full sample)
* ----------------------------------------------------------

use FinalDatasetExtra, clear


replace govt_cons_pergdp =govt_cons_pergdp /100

replace gdspgdp_wdi=gdspgdp_wdi/100

replace fdinipgdp_wdi =fdinipgdp_wdi /100

local controls ltot_wdi govt_cons kaopen er_RR_crawl er_RR_float er_RR_free er_RR_dual 
xi: reg underval  `controls' i.iso i.year ///
if (iso_code!="IRQ" & iso_code!="LAO" & iso_code!="PRK"), robust
outreg2 `controls' using Table_10, excel  tstat bdec(3) tdec(2) nocons nor2 replace 

xi: reg underval  `controls' gds i.country i.year ///
if (iso_code!="IRQ" & iso_code!="LAO" & iso_code!="PRK"), robust
outreg2 `controls' gds using Table_10, excel  tstat bdec(3) tdec(2) nocons nor2 nonotes append 


xi: reg underval `controls' gds fdi i.country i.year  ///
if (iso_code!="IRQ" & iso_code!="LAO" & iso_code!="PRK"), robust
outreg2 `controls' gds fdi using Table_10, excel  tstat bdec(3) tdec(2) nocons nor2 nonotes append 

xi: reg underval  `controls' gds fdi inflation_wdi i.country i.year ///
if (iso_code!="IRQ" & iso_code!="LAO" & iso_code!="PRK"), robust
outreg2 `controls' gds fdi inflation_wdi using Table_10, excel  tstat bdec(3) tdec(2) nocons nor2 nonotes append 

